# XMPP Android Client

A modern Android XMPP client built with Kotlin, featuring real-time messaging, contact management, and presence updates.

## Features

- **XMPP Connection Management**: Connect to any XMPP server with secure authentication
- **Real-time Messaging**: Send and receive messages instantly
- **Contact Management**: Add, view, and manage your XMPP contacts
- **Presence Updates**: See when contacts are online, away, or offline
- **Message Persistence**: All messages are stored locally using Room database
- **Modern UI**: Clean Material Design interface with dark/light theme support
- **Background Service**: Maintains connection even when app is in background

## Architecture

- **MVVM Pattern**: Uses ViewModel and LiveData for reactive UI updates
- **Dependency Injection**: Powered by Hilt for clean dependency management
- **Room Database**: Local storage for messages and contacts
- **Kotlin Coroutines**: Asynchronous programming for smooth performance
- **Smack Library**: XMPP implementation using the popular Smack library

## Project Structure

```
app/
├── src/main/java/com/example/xmppclient/
│   ├── data/
│   │   ├── dao/           # Database access objects
│   │   ├── database/      # Room database configuration
│   │   └── entity/        # Data entities
│   ├── di/                # Hilt dependency injection modules
│   ├── repository/        # Data repositories
│   ├── service/           # Background services
│   ├── ui/
│   │   ├── adapter/       # RecyclerView adapters
│   │   └── fragments/     # UI fragments
│   ├── viewmodel/         # ViewModels for UI logic
│   └── xmpp/              # XMPP connection management
└── src/main/res/
    ├── layout/            # XML layouts
    ├── drawable/          # Icons and drawables
    ├── values/            # Colors, strings, themes
    └── menu/              # Menu resources
```

## Dependencies

- **Smack XMPP Library**: For XMPP protocol implementation
- **Hilt**: Dependency injection
- **Room**: Local database
- **Material Components**: Modern UI design
- **Kotlin Coroutines**: Asynchronous programming
- **ViewPager2**: Fragment navigation
- **RecyclerView**: List displays

## Setup Instructions

1. Clone the repository
2. Open in Android Studio
3. Sync project with Gradle files
4. Build and run on Android device/emulator
5. Enter your XMPP server credentials in the login screen

## XMPP Server Compatibility

This client is compatible with standard XMPP servers including:
- ejabberd
- Prosody
- Openfire
- Tigase
- MongooseIM

## Security Features

- TLS encryption support
- SASL authentication
- Secure credential storage
- Connection validation

## Contributing

1. Fork the repository
2. Create a feature branch
3. Commit your changes
4. Push to the branch
5. Create a Pull Request

## License

This project is open source and available under the [MIT License](LICENSE).
