package com.example.xmppclient.data.dao

import androidx.room.*
import com.example.xmppclient.data.entity.Contact
import kotlinx.coroutines.flow.Flow

@Dao
interface ContactDao {

    @Query("SELECT * FROM contacts ORDER BY name ASC")
    fun getAllContacts(): Flow<List<Contact>>

    @Query("SELECT * FROM contacts WHERE jid = :jid LIMIT 1")
    suspend fun getContact(jid: String): Contact?

    @Query("SELECT * FROM contacts WHERE jid = :jid LIMIT 1")
    fun getContactFlow(jid: String): Flow<Contact?>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertContact(contact: Contact)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertContacts(contacts: List<Contact>)

    @Update
    suspend fun updateContact(contact: Contact)

    @Delete
    suspend fun deleteContact(contact: Contact)

    @Query("UPDATE contacts SET presenceStatus = :status, statusMessage = :statusMessage, lastSeen = :lastSeen WHERE jid = :jid")
    suspend fun updatePresence(jid: String, status: String, statusMessage: String?, lastSeen: Long?)

    @Query("SELECT COUNT(*) FROM contacts")
    suspend fun getContactCount(): Int
}
