package com.example.xmppclient.data.dao

import androidx.room.*
import com.example.xmppclient.data.entity.Message
import kotlinx.coroutines.flow.Flow

@Dao
interface MessageDao {

    @Query("SELECT * FROM messages WHERE (fromJid = :jid OR toJid = :jid) ORDER BY timestamp ASC")
    fun getMessagesForContact(jid: String): Flow<List<Message>>

    @Query("SELECT * FROM messages WHERE (fromJid = :jid1 AND toJid = :jid2) OR (fromJid = :jid2 AND toJid = :jid1) ORDER BY timestamp ASC")
    fun getConversation(jid1: String, jid2: String): Flow<List<Message>>

    @Query("SELECT * FROM messages ORDER BY timestamp DESC")
    fun getAllMessages(): Flow<List<Message>>

    @Query("SELECT * FROM messages WHERE messageId = :messageId LIMIT 1")
    suspend fun getMessageById(messageId: String): Message?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertMessage(message: Message): Long

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertMessages(messages: List<Message>)

    @Update
    suspend fun updateMessage(message: Message)

    @Delete
    suspend fun deleteMessage(message: Message)

    @Query("DELETE FROM messages WHERE (fromJid = :jid OR toJid = :jid)")
    suspend fun deleteMessagesForContact(jid: String)

    @Query("UPDATE messages SET isRead = 1 WHERE fromJid = :fromJid AND isRead = 0")
    suspend fun markMessagesAsRead(fromJid: String)
}
