package com.example.xmppclient.data.database

import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import android.content.Context
import com.example.xmppclient.data.dao.ContactDao
import com.example.xmppclient.data.dao.MessageDao
import com.example.xmppclient.data.entity.Contact
import com.example.xmppclient.data.entity.Message

@Database(
    entities = [Message::class, Contact::class],
    version = 1,
    exportSchema = false
)
abstract class XMPPDatabase : RoomDatabase() {

    abstract fun messageDao(): MessageDao
    abstract fun contactDao(): ContactDao

    companion object {
        @Volatile
        private var INSTANCE: XMPPDatabase? = null

        fun getDatabase(context: Context): XMPPDatabase {
            return INSTANCE ?: synchronized(this) {
                val instance = Room.databaseBuilder(
                    context.applicationContext,
                    XMPPDatabase::class.java,
                    "xmpp_database"
                ).build()
                INSTANCE = instance
                instance
            }
        }
    }
}
