package com.example.xmppclient.di

import android.content.Context
import com.example.xmppclient.data.dao.ContactDao
import com.example.xmppclient.data.dao.MessageDao
import com.example.xmppclient.data.database.XMPPDatabase
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object DatabaseModule {

    @Provides
    @Singleton
    fun provideXMPPDatabase(@ApplicationContext context: Context): XMPPDatabase {
        return XMPPDatabase.getDatabase(context)
    }

    @Provides
    fun provideMessageDao(database: XMPPDatabase): MessageDao {
        return database.messageDao()
    }

    @Provides
    fun provideContactDao(database: XMPPDatabase): ContactDao {
        return database.contactDao()
    }
}
