package com.example.xmppclient.repository

import com.example.xmppclient.data.dao.ContactDao
import com.example.xmppclient.data.entity.Contact
import kotlinx.coroutines.flow.Flow
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class ContactRepository @Inject constructor(
    private val contactDao: ContactDao
) {

    fun getAllContacts(): Flow<List<Contact>> {
        return contactDao.getAllContacts()
    }

    suspend fun getContact(jid: String): Contact? {
        return contactDao.getContact(jid)
    }

    fun getContactFlow(jid: String): Flow<Contact?> {
        return contactDao.getContactFlow(jid)
    }

    suspend fun insertContact(contact: Contact) {
        contactDao.insertContact(contact)
    }

    suspend fun insertContacts(contacts: List<Contact>) {
        contactDao.insertContacts(contacts)
    }

    suspend fun updateContact(contact: Contact) {
        contactDao.updateContact(contact)
    }

    suspend fun deleteContact(contact: Contact) {
        contactDao.deleteContact(contact)
    }

    suspend fun updatePresence(jid: String, status: String, statusMessage: String?, lastSeen: Long?) {
        contactDao.updatePresence(jid, status, statusMessage, lastSeen)
    }

    suspend fun getContactCount(): Int {
        return contactDao.getContactCount()
    }
}
