package com.example.xmppclient.repository

import com.example.xmppclient.data.dao.MessageDao
import com.example.xmppclient.data.entity.Message
import kotlinx.coroutines.flow.Flow
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class MessageRepository @Inject constructor(
    private val messageDao: MessageDao
) {

    fun getMessagesForContact(jid: String): Flow<List<Message>> {
        return messageDao.getMessagesForContact(jid)
    }

    fun getConversation(jid1: String, jid2: String): Flow<List<Message>> {
        return messageDao.getConversation(jid1, jid2)
    }

    fun getAllMessages(): Flow<List<Message>> {
        return messageDao.getAllMessages()
    }

    suspend fun getMessageById(messageId: String): Message? {
        return messageDao.getMessageById(messageId)
    }

    suspend fun insertMessage(message: Message): Long {
        return messageDao.insertMessage(message)
    }

    suspend fun insertMessages(messages: List<Message>) {
        messageDao.insertMessages(messages)
    }

    suspend fun updateMessage(message: Message) {
        messageDao.updateMessage(message)
    }

    suspend fun deleteMessage(message: Message) {
        messageDao.deleteMessage(message)
    }

    suspend fun deleteMessagesForContact(jid: String) {
        messageDao.deleteMessagesForContact(jid)
    }

    suspend fun markMessagesAsRead(fromJid: String) {
        messageDao.markMessagesAsRead(fromJid)
    }
}
