package com.example.xmppclient.service

import android.app.Service
import android.content.Intent
import android.os.IBinder
import androidx.lifecycle.LifecycleService
import com.example.xmppclient.xmpp.XMPPConnectionManager
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class XMPPService : LifecycleService() {

    @Inject
    lateinit var xmppManager: XMPPConnectionManager

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        super.onStartCommand(intent, flags, startId)

        // Keep the XMPP connection alive in the background
        // Handle reconnections and maintain presence

        return START_STICKY
    }

    override fun onBind(intent: Intent): IBinder? {
        super.onBind(intent)
        return null
    }

    override fun onDestroy() {
        super.onDestroy()
        xmppManager.disconnect()
    }
}
