package com.example.xmppclient.ui.fragments

import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.example.xmppclient.databinding.FragmentContactsBinding
import com.example.xmppclient.ui.ChatActivity
import com.example.xmppclient.ui.adapter.ContactAdapter
import com.example.xmppclient.viewmodel.ContactsViewModel
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.launch

@AndroidEntryPoint
class ContactsFragment : Fragment() {

    private var _binding: FragmentContactsBinding? = null
    private val binding get() = _binding!!

    private val viewModel: ContactsViewModel by viewModels()
    private lateinit var contactAdapter: ContactAdapter

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentContactsBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        setupRecyclerView()
        observeViewModel()
    }

    private fun setupRecyclerView() {
        contactAdapter = ContactAdapter { contact ->
            // Navigate to chat activity
            val intent = Intent(requireContext(), ChatActivity::class.java).apply {
                putExtra("contactJid", contact.jid)
                putExtra("contactName", contact.name)
            }
            startActivity(intent)
        }

        binding.recyclerViewContacts.apply {
            layoutManager = LinearLayoutManager(requireContext())
            adapter = contactAdapter
        }
    }

    private fun observeViewModel() {
        viewLifecycleOwner.lifecycleScope.launch {
            viewModel.contacts.collect { contacts ->
                contactAdapter.submitList(contacts)

                if (contacts.isEmpty()) {
                    binding.emptyStateContacts.visibility = View.VISIBLE
                    binding.recyclerViewContacts.visibility = View.GONE
                } else {
                    binding.emptyStateContacts.visibility = View.GONE
                    binding.recyclerViewContacts.visibility = View.VISIBLE
                }
            }
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}
