package com.example.xmppclient.ui.fragments

import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.example.xmppclient.databinding.FragmentConversationsBinding
import com.example.xmppclient.ui.ChatActivity
import com.example.xmppclient.ui.adapter.ConversationAdapter
import com.example.xmppclient.viewmodel.ConversationsViewModel
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.launch

@AndroidEntryPoint
class ConversationsFragment : Fragment() {

    private var _binding: FragmentConversationsBinding? = null
    private val binding get() = _binding!!

    private val viewModel: ConversationsViewModel by viewModels()
    private lateinit var conversationAdapter: ConversationAdapter

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentConversationsBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        setupRecyclerView()
        observeViewModel()
    }

    private fun setupRecyclerView() {
        conversationAdapter = ConversationAdapter { conversation ->
            // Navigate to chat activity
            val intent = Intent(requireContext(), ChatActivity::class.java).apply {
                putExtra("contactJid", conversation.contactJid)
                putExtra("contactName", conversation.contactName)
            }
            startActivity(intent)
        }

        binding.recyclerViewConversations.apply {
            layoutManager = LinearLayoutManager(requireContext())
            adapter = conversationAdapter
        }
    }

    private fun observeViewModel() {
        viewLifecycleOwner.lifecycleScope.launch {
            viewModel.conversations.collect { conversations ->
                conversationAdapter.submitList(conversations)

                if (conversations.isEmpty()) {
                    binding.emptyStateConversations.visibility = View.VISIBLE
                    binding.recyclerViewConversations.visibility = View.GONE
                } else {
                    binding.emptyStateConversations.visibility = View.GONE
                    binding.recyclerViewConversations.visibility = View.VISIBLE
                }
            }
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}
