package com.example.xmppclient.viewmodel

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.example.xmppclient.xmpp.XMPPConnectionManager
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class LoginViewModel @Inject constructor(
    private val xmppManager: XMPPConnectionManager
) : ViewModel() {

    private val _loginState = MutableStateFlow<LoginState>(LoginState.Idle)
    val loginState: StateFlow<LoginState> = _loginState

    sealed class LoginState {
        object Idle : LoginState()
        object Loading : LoginState()
        object Success : LoginState()
        data class Error(val message: String) : LoginState()
    }

    fun login(username: String, password: String, server: String, port: Int) {
        viewModelScope.launch {
            _loginState.value = LoginState.Loading

            try {
                val success = xmppManager.connect(username, password, server, port)
                if (success) {
                    _loginState.value = LoginState.Success
                } else {
                    _loginState.value = LoginState.Error("Failed to connect. Please check your credentials and server settings.")
                }
            } catch (e: Exception) {
                _loginState.value = LoginState.Error("Connection error: ${e.message}")
            }
        }
    }
}
