# KISS_PGPfone (final)

FastAPI rendezvous/relay that **serves the web client** and **self-hosts Noble** via `/vendor/*` proxy.
Web client uses **ChaCha20-Poly1305 (Noble)** correctly (nonce at construction) and the server relays
audio with a **single reader** (only caller starts the pipe), avoiding duplicate `recv()`.

## Deploy
```bash
python -m venv .venv && source .venv/bin/activate
pip install -r requirements.txt
python server.py   # 0.0.0.0:8000
```
Behind Caddy/Nginx, reverse_proxy to 127.0.0.1:8000. Visit `https://vc.mpgb.xyz/`.

## Quick checks
```bash
curl -i 'https://vc.mpgb.xyz/healthz'
curl -i 'https://vc.mpgb.xyz/vendor/@noble/hashes@1.3.2/sha256?target=es2022&bundle'
```
The second should be `200` with `Content-Type: application/javascript`.

## Notes
- Verify SAS verbally before connecting media.
- ScriptProcessorNode is deprecated; for production, move to AudioWorklet + Opus.
