# KISS_PGPfone

Minimal PGPfone-style prototype (FastAPI serves the web client).

## What’s inside
- `server.py` — FastAPI rendezvous + opaque WebSocket relay; serves web client and proxies Noble modules under `/vendor/*`. Auto-starts uvicorn on run.
- `client.py` — Python CLI softphone (ChaCha20-Poly1305, X25519, SAS), 16 kHz PCM.
- `web/index.html` — Zero-build Noble JS web client (ChaCha20-Poly1305, X25519).

## Quick start
```bash
python -m venv .venv && source .venv/bin/activate
pip install -r requirements.txt
python server.py  # 0.0.0.0:8000
```
Then visit your server origin (`https://vc.mpgb.xyz/`).

## Reverse proxy (vc.mpgb.xyz)
Caddy:
```
vc.mpgb.xyz {
  encode zstd gzip
  reverse_proxy 127.0.0.1:8000
}
```
Nginx:
```
server {
  server_name vc.mpgb.xyz;
  listen 443 ssl http2;
  # ssl certs...
  location /ws/ {
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    proxy_http_version 1.1;
    proxy_set_header Host $host;
    proxy_pass http://127.0.0.1:8000;
  }
  location / {
    proxy_set_header Host $host;
    proxy_set_header X-Forwarded-For $remote_addr;
    proxy_pass http://127.0.0.1:8000;
  }
}
```

## Notes
- Verify the SAS verbally to defeat MITM.
- Prototype only; re-key if calls are extremely long so counters never wrap.
