# KISS_PGPfone (updated)

FastAPI rendezvous/relay that **serves the web client** and **self-hosts Noble** via `/vendor/*` proxy.

## What’s inside
- `server.py` — FastAPI app; mounts `web/`, serves `/`, proxies esm.sh via `/vendor/*` with aliases `/@noble/*`, `/es2022/*`, `/v*/**`. Forwards query strings and returns proper JS MIME.\n- `web/index.html` — Zero-build web client using Noble **(pinned versions, `?target=es2022&bundle`)**.\n- `client.py` — Python CLI softphone (ChaCha20-Poly1305, X25519, SAS).\n- `requirements.txt` — deps.\n
## Deploy
```bash
python -m venv .venv && source .venv/bin/activate
pip install -r requirements.txt
python server.py   # 0.0.0.0:8000
```
Behind Caddy/Nginx, reverse_proxy to 127.0.0.1:8000. Visit `https://vc.mpgb.xyz/`.

## Quick checks
```bash
curl -i 'https://vc.mpgb.xyz/healthz'
curl -i 'https://vc.mpgb.xyz/vendor/@noble/hashes@1.3.2/sha256?target=es2022&bundle'
```
Both should be `200` with `Content-Type: application/javascript` on the second.
