
#!/usr/bin/env bash
set -euo pipefail
echo "[1/5] npm install"
npm i
echo "[2/5] build web"
npm run build
echo "[3/5] add/copy android platform"
npx cap add android || true
npx cap copy android || npx cap copy
echo "[4/5] assemble debug APK"
./android/gradlew -p android assembleDebug
echo "[5/5] Install to connected device (optional)"
if command -v adb >/dev/null 2>&1; then
  adb install -r android/app/build/outputs/apk/debug/app-debug.apk || true
else
  echo "adb not found; skipping install."
fi
echo "Done. APK at android/app/build/outputs/apk/debug/app-debug.apk"
