import { EventData, Frame, Page, TextField, TextView } from "@nativescript/core";
import { db } from "~/services/db";
import { cryptoService } from "~/services/crypto";
let page: Page; let noteId: number | null = null;
export async function onNavTo(args: EventData) { page = <Page>args.object; const ctx = (page as any).navigationContext || { id: null }; noteId = ctx.id; if (noteId) { const row = await db.get(noteId); if (row) { try { const blob = JSON.parse(row.blob); const note = cryptoService.decryptJSON(blob); (<TextField>page.getViewById("title")).text = note.title || ""; (<TextView>page.getViewById("body")).text = note.body || ""; } catch (_) {} } } }
export async function onSave() { const title = (<TextField>page.getViewById("title")).text || ""; const body = (<TextView>page.getViewById("body")).text || ""; const blob = cryptoService.encryptJSON({ title, body }); const blobStr = JSON.stringify(blob); const id = await db.upsert(noteId, blobStr); noteId = id; Frame.topmost().goBack(); }
export async function onDelete() { if (!noteId) { Frame.topmost().goBack(); return; } await db.remove(noteId); Frame.topmost().goBack(); }
