import { EventData, Frame, fromObject, Page } from "@nativescript/core";
import { db } from "~/services/db";
import { cryptoService } from "~/services/crypto";
let page: Page; let vm = fromObject({ items: [] as any[] }); let idleTimer: any;
function scheduleAutoLock() { if (idleTimer) clearTimeout(idleTimer); idleTimer = setTimeout(() => { cryptoService.lock(); Frame.topmost().navigate({ moduleName: "pages/login/login-page", clearHistory: true }); }, 3*60*1000); }
export async function onNavTo(args: EventData) { page = <Page>args.object; page.bindingContext = vm; await reload(); scheduleAutoLock(); }
export function onUnloaded() { if (idleTimer) clearTimeout(idleTimer); }
async function reload() {
  const rows = await db.list(); const items: any[] = [];
  for (const r of rows) {
    try { const blob = JSON.parse(r.blob); const note = cryptoService.decryptJSON(blob);
      items.push({ id: r.id, title: note.title || "(Untitled)", preview: (note.body || "").slice(0, 80).replace(/\n/g, " "), date: new Date(r.updated_at).toLocaleString() });
    } catch (e) { items.push({ id: r.id, title: "(Decryption error)", preview: "", date: new Date(r.updated_at).toLocaleString() }); }
  }
  vm.set("items", items);
}
export function onItemTap(args) { const item = vm.get("items")[args.index]; Frame.topmost().navigate({ moduleName: "pages/editor/editor-page", context: { id: item.id } }); }
export function onNew() { Frame.topmost().navigate({ moduleName: "pages/editor/editor-page", context: { id: null } }); }
export function onLock() { cryptoService.lock(); Frame.topmost().navigate({ moduleName: "pages/login/login-page", clearHistory: true }); }
