import { EventData, Frame, Page, TextField } from "@nativescript/core";
import { cryptoService } from "~/services/crypto";
import { db } from "~/services/db";
let page: Page;
export async function onLoaded(args: EventData) { page = <Page>args.object; }
export async function onUnlock() {
  const pass = (<TextField>page.getViewById("pass")).text?.trim() ?? "";
  if (!pass) return;
  const ok = await cryptoService.unlockWithPassphrase(pass);
  if (!ok) { alert({ title: "Unlock failed", message: "Wrong passphrase", okButtonText: "OK" }); return; }
  await db.init();
  Frame.topmost().navigate({ moduleName: "pages/list/list-page", clearHistory: true });
}
