// Optional: platform keystore/keychain wrapping stubs
export const keystore = {
  isSupported(): boolean {
    if ((global as any).isAndroid) return true;
    if ((global as any).isIOS) return true;
    return false;
  },
  async wrapMasterKey(mk: Uint8Array): Promise<{ wrapped: Uint8Array }> { return { wrapped: mk }; },
  async unwrapMasterKey(wrapped: Uint8Array): Promise<Uint8Array> { return wrapped; }
};