#!/usr/bin/env bash
set -euo pipefail
export DISPLAY="${DISPLAY:-:0}"
XAUTH="$(xauth info 2>/dev/null | awk "/Authority file/ {print \$3}" || true)"
if [[ -z "${XAUTH:-}" || ! -r "$XAUTH" ]]; then
  if [[ -r "$HOME/.Xauthority" ]]; then
    XAUTH="$HOME/.Xauthority"
  elif [[ -r /var/run/lightdm/root/:0 ]]; then
    install -m600 -o "$USER" -g "$USER" /var/run/lightdm/root/:0 "$HOME/.Xauthority"
    XAUTH="$HOME/.Xauthority"
  fi
fi
export XAUTHORITY="$XAUTH"
for i in {1..60}; do
  if xset q >/dev/null 2>&1; then break; fi
  sleep 1
done
xrandr -q || true
echo "Using DISPLAY=$DISPLAY XAUTHORITY=$XAUTHORITY"
exec /usr/bin/sunshine
